//--------------------------------------------------------------------------------
// Company: FE
// Engineer: A. Trost
//
// Design Name: proc
// Project Name: Red Pitaya V0.94 obdelava signalov
// Target Device: Red Pitaya
// Tool versions: Vivado 2025
// Description: skaliranje signalov iz ASG
// Sys Registers: 403_00050 ID; 00054 a
//------------------------------------------------------------------------------

module proc (
    input  logic              clk_i,       // bus and ADC clock
    input  logic              rstn_i,      // bus reset - active low
    input  logic              clk2_i,

    input  logic signed [13:0] dat_a_i,    // input source
    input  logic signed [13:0] dat_b_i,    // currently unused
    output logic       [13:0] dat_a_o,     // original input
    output logic       [13:0] dat_b_o,     // transformed input

    input  logic [31:0] sys_addr,     // bus address
    input  logic [31:0] sys_wdata,    // bus write data          
    input  logic        sys_wen,      // bus write enable
    input  logic        sys_ren,      // bus read enable
    output logic [31:0] sys_rdata,    // bus read data
    output logic        sys_err,      // bus error indicator
    output logic        sys_ack       // bus acknowledge signal
);

logic [31:0] set = 0;                  

// Signal processing instance, drive dat_a_o
sigproc i_sp (
  //.clk (clk_i),
  .set (set),
  .din (dat_a_i),
  .dout(dat_a_o)
 );

// Digital filter instance, drive dat_b_o
filt i_filt (
  .clk (clk_i),
  .x   (dat_a_i),
  .y   (dat_b_o)
 );           

// no error signal
assign sys_err = 1'b0;

    // ---------------------------------------------------------------------
    // Register write / acknowledge logic
    // ---------------------------------------------------------------------
    always_ff @(posedge clk_i) begin
        if (!rstn_i) begin
            set <= 0;
            sys_ack <= 1'b0;
        end else begin
            sys_ack <= sys_wen | sys_ren;

            if (sys_wen) begin
                // address decode: write register A
                if (sys_addr[19:0] == 20'h00054)
                    set <= sys_wdata;
            end
        end
    end

    // ---------------------------------------------------------------------
    // Readback multiplexer
    // ---------------------------------------------------------------------
    always_comb begin
        unique case (sys_addr[19:0])
            20'h00050: sys_rdata = 32'hFE250000;  // ID
            20'h00054: sys_rdata = set;           // set value
            default:   sys_rdata = 32'h00000000;
        endcase
    end

endmodule
