library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;
use IEEE.math_real.all;

entity TestFIR is
end TestFIR;

architecture Behavioral of TestFIR is

 component filt
 port(
   clk : in std_logic;
   x : in signed(13 downto 0);
   y : out signed(13 downto 0)
 );
 end component;

 signal clk : std_logic:= '0';
 signal x : signed(13 downto 0);
 signal y : signed(13 downto 0);
 constant Ts : time := 30 ns;
 signal endsim: boolean := false;
begin

uut: filt port map (
     clk => clk,
     x => x,
     y => y
);

-- Clock generator
clk_gen: process
begin
 if not endsim then
 clk <= '1';  wait for Ts/2;
 clk <= '0';  wait for Ts/2;
 else
   wait;
 end if;
end process;	

-- Generiraj prelet sinusnega signala za vhod vezja
singen : process(clk)
 variable ods: integer := 0;  -- stevec odsekov
 variable fi: real:= 0.0;
 variable d: real := 0.002;  -- zacetni korak
 variable si: integer;
begin
 if(rising_edge(clk)) then
  if ods > 64 then   -- po 64 ciklih je nov odsek
   ods := 0;
   d := d * 1.1;     -- zmanjsaj periodo
   if d >= 0.5 then 
     endsim <= true; 
   end if;    
  else
   ods := ods + 1;
  end if;

  fi := fi + d;
  si := integer(8000.0*sin(MATH_2_PI*fi)+0.49);  -- sinus, amp=100
  x <= to_signed(si, 14);      
 end if;
end process;

end Behavioral;