library ieee, work;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.procpak.all;

entity program is
    Port (
		address	: IN STD_LOGIC_VECTOR (11 DOWNTO 0);
		clken		: IN STD_LOGIC  := '1';
		clock		: IN STD_LOGIC  := '1';
		data		: IN STD_LOGIC_VECTOR (15 DOWNTO 0);
		wren		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
	);
end program;

architecture Behavioral of program is
  
type memory is array(0 to 4095) of unsigned(15 downto 0);
signal m : memory := (
0=> lda & x"00f",
1=> sta & x"00d",
2=> outp & x"001",
3=> lda & x"010",
4=> sta & x"00e",
5=> outp & x"002",
6=> inp & x"004",
7=> jze & x"006",
8=> lda & x"00d",
9=> add & x"011",
10=> sta & x"00d",
11=> outp & x"001",
12=> jmp & x"006",
13=> x"0000",
14=> x"0000",
15=> x"0005",
16=> x"000a",
17=> x"0001",
others => x"0000"
);

begin

 p: process(clock)
 begin
   if rising_edge(clock) and clken='1' then
		q <= STD_LOGIC_VECTOR(m(to_integer(unsigned(address))));
  
      if wren = '1' then
        m(to_integer(unsigned(address))) <= unsigned(data);
      end if;
   end if;
 end process;

end Behavioral;
