library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity proc is
  Port ( clk, ce : in STD_LOGIC;
         rst : in STD_LOGIC;
			rw: out unsigned(1 downto 0);
			adr: out unsigned (7 downto 0);
			dataIO: in unsigned(11 downto 0);
         dataProc: out unsigned(11 downto 0)
		 );
end proc;

architecture Opis of proc is
 signal data, datin, dataout: unsigned(15 downto 0);
 signal dataram, datacpu: std_logic_vector(15 downto 0);

 signal adrsig: unsigned (11 downto 0);
 signal address: std_logic_vector(11 downto 0); -- 2k RAM
 signal wren, rd, wr: std_logic;
 
begin

 address <= std_logic_vector(adrsig);
 datacpu <= std_logic_vector(dataout);
 data <= unsigned(dataram);
 
 ram: entity work.program port map (
   clock => clk,
	clken => ce, 
   address => address,
	data => datacpu, 
	wren => wren, 
	q => dataram);	
	
 cpu: entity work.cpu16 port map (
   clk => clk,
	ce => ce,
	rst => rst,
	data => data,
	datin => datin,
   adr => adrsig, 
	we => wren,
	datout => dataout,
	weout => wr,
	rdout => rd
 );
   
 adr <= adrsig(7 downto 0);
 -- nastavi kombiniran wr, ki je aktiven le en cikel ure
 rw <= (rd and ce) & (wr and ce);
 datin <= "0000" & dataIO;
 dataProc <= dataout(11 downto 0);
 
end Opis;