

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity grafika is
 port (
   clk  : in std_logic;
   x, y : in unsigned(11 downto 0);
	x1, y1 : in unsigned(11 downto 0);
	rgb  : out unsigned(5 downto 0)
 );
end grafika;

architecture RTL of grafika is
 
constant rom: unsigned((32*32)-1 downto 0) := ( 
"00000000000000000000000000000000" &
"00000000001111111111100000000000" &
"00000000111111111111111000000000" &
"00000001111111111111111100000000" &
"00000111111111111111111111000000" &
"00001111111111111111111111100000" &
"00001111111111111111111111100000" &
"00011111111111111111111111110000" &
"00111111111111111111111111111000" &
"00111111111111111111111111111000" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"01111111111111111111111111111100" &
"00111111111111111111111111111000" &
"00111111111111111111111111111000" &
"00011111111111111111111111110000" &
"00001111111111111111111111100000" &
"00001111111111111111111111100000" &
"00000111111111111111111111000000" &
"00000001111111111111111100000000" &
"00000000111111111111111000000000" &
"00000000001111111111100000000000" & 
"00000000000000000000000000000000" &
"00000000000000000000000000000000"   );

 signal adr : unsigned(9 downto 0);
 signal data : std_logic;
 signal xt, yt: unsigned(11 downto 0);
begin
 
 xt <= x-x1;
 yt <= y-y1;
 
 process(clk) -- doloci izhodno barvo
 begin
  if rising_edge(clk) then
   if x<800 and y<600 then  -- vidni del slike
		
		if xt<32 and yt<32 then -- znotraj slicice
		  rgb <= "111100";
		else
		  if x(4 downto 0)="11111" or y(4 downto 0)="11111" then
				rgb <= "001111";
		  else
				rgb <= "010101";
		  end if;
		end if;
		
	else -- zatemnjen del slike
		rgb <= "000000";
	end if;
  end if;
 end process;
end RTL;

