//--------------------------------------------------------------------------------
// Company: FE
// Engineer: A. Trost
//
// Design Name: proc
// Project Name: Red Pitaya V0.94 obdelava signalov
// Target Device: Red Pitaya
// Tool versions: Vivado 2025
// Description: skaliranje signalov iz ASG
// Sys Registers: 403_00050 ID; 00054 a
//------------------------------------------------------------------------------

module proc (
    input  logic              clk_i,       // bus and ADC clock
    input  logic              rstn_i,      // bus reset - active low
    input  logic              clk2_i,

    input  logic signed [13:0] dat_a_i,    // input source
    input  logic signed [13:0] dat_b_i,    // currently unused
    output logic       [13:0] dat_a_o,     // original input
    output logic       [13:0] dat_b_o,     // transformed input

    input  logic [31:0] sys_addr,     // bus address
    input  logic [31:0] sys_wdata,    // bus write data          
    input  logic        sys_wen,      // bus write enable
    input  logic        sys_ren,      // bus read enable
    output logic [31:0] sys_rdata,    // bus read data
    output logic        sys_err,      // bus error indicator
    output logic        sys_ack       // bus acknowledge signal
);

logic [7:0] a = 8'd16;  // example parameter, amplitude scaling
logic signed [22:0] mul_a;

assign mul_a = dat_a_i * $signed({1'b0, a});

// scaled input to CH1
assign dat_a_o = mul_a[17:4];                   

logic signed [13:0] x, y;

assign x = dat_a_i;

// Digital filter instance
filt i_filt (
    .ap_clk (clk_i),
    .ap_rst (rst),
    .x (x),
    .y (y)
 );

// filtered data to CH2
assign dat_b_o = y;            

// no error signal
assign sys_err = 1'b0;

    // ---------------------------------------------------------------------
    // Register write / acknowledge logic
    // ---------------------------------------------------------------------
    always_ff @(posedge clk_i) begin
        if (!rstn_i) begin
            a      <= 8'h10;
            sys_ack <= 1'b0;
        end else begin
            sys_ack <= sys_wen | sys_ren;

            if (sys_wen) begin
                // address decode: write register A
                if (sys_addr[19:0] == 20'h00054)
                    a <= sys_wdata[7:0];
            end
        end
    end

    // ---------------------------------------------------------------------
    // Readback multiplexer
    // ---------------------------------------------------------------------
    always_comb begin
        unique case (sys_addr[19:0])
            20'h00050: sys_rdata = 32'hFE250001;     // ID
            20'h00054: sys_rdata = {24'h000000, a};  // amplitude
            default:   sys_rdata = 32'h00000000;
        endcase
    end

endmodule
