module filt (
 input logic ap_clk,
 input logic ap_rst,
 input logic signed [13:0] x,
 output logic signed [13:0] y
);

// Shift register of 8 samples
logic signed [13:0] samples [0:7];

// Update shift register
always_ff @(posedge ap_clk) begin
 samples[0] <= x;
 for (int i = 1; i < 8; i++) begin
  samples[i] <= samples[i-1];
 end
end

// Compute sum and average
logic signed [17:0] sum; // enough bits for 8 * 14 bits

always_comb begin
 sum = 0;
 for (int i = 0; i < 8; i++) begin
  sum += samples[i];
 end
end

// Average = sum / 8 (arithmetic shift right by 3)
always_ff @(posedge ap_clk) begin
 y <= sum >>> 3;
end

endmodule